jQuery(function ($) {
    $(document).on('click', '.total-install-plugin', function () {
        event.preventDefault();
        var $button = $(this);

        if ($button.hasClass('updating-message')) {
            return;
        }

        wp.updates.installPlugin({
            slug: $button.data('slug')
        });
    });

    $(document).on('click', '.total-activate-plugin', function () {
        event.preventDefault();
        var $button = $(this);
        $button.addClass('updating-message').html(importer_params.activating_text);

        total_activate_plugin($button);

    });

    $(document).on('wp-plugin-installing', function (event, args) {
        event.preventDefault();

        $('.total-install-plugin').addClass('updating-message').html(importer_params.installing_text);

    });

    $(document).on('wp-plugin-install-success', function (event, response) {

        event.preventDefault();
        var $button = $('.total-install-plugin');

        $button.html(importer_params.activating_text);

        setTimeout(function () {
            total_activate_plugin($button);
        }, 1000);

    });

    function total_activate_plugin($button) {
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'total_activate_plugin',
                slug: $button.data('slug'),
                file: $button.data('filename')
            },
        }).done(function (result) {
            var result = JSON.parse(result)
            if (result.success) {
                $button.removeClass('total-activate-plugin total-install-plugin updating-message').html(importer_params.importer_page).attr('href', importer_params.importer_url);
            } else {
                $button.removeClass('updating-message').html(importer_params.error);
            }

        });
    }
});